/*

mp3.js
Usage:
// $config['additional_javascript'][] = 'js/jquery.min.js';
$config['additional_javascript'][] = 'js/mp3.js';
*/

document.addEventListener('DOMContentLoaded', function() {
// Grab all the mp3 links within the thread
let mp3Links = document.querySelectorAll('.thread .file a[href$=".mp3"]');

// Iterate over each link and replace with audio player
mp3Links.forEach(function(link) {
    // Create a new audio element
    let audio = document.createElement('audio');
    audio.controls = true; // Enable audio controls like play, pause, volume, etc.
    audio.src = link.href; // Set the source to the mp3 link

    // Create a source element for better compatibility
    let source = document.createElement('source');
    source.src = link.href;
    source.type = "audio/mpeg";
    audio.appendChild(source);

    // Replace the link's parent (which contains both the link and the image) with the audio player
    link.parentNode.parentNode.replaceChild(audio, link.parentNode);
});
});